<?php
// 	initialize
// 	extensions to fetch, an empty array will return all extensions which is best for real security
$ext = array("php","html","js");

// 	directories to ignore, an empty array will check all directories
$skip = array("protected");

// 	use define statements or enter values directly in the mysqli_connect
define('SERVER','localhost');
define('USER','your user name');
define('PASS','your password');
define('DATABASE','database name');

$db = mysqli_connect(SERVER,USER,PASS,DATABASE);

$dir = new RecursiveDirectoryIterator(PATH);
$iter = new RecursiveIteratorIterator($dir);
while ($iter->valid())
{
	// 	skip unwanted directories
	if (!$iter->isDot() && !in_array($iter->getSubPath(), $skip))
	{
		// 	get specific file extensions
		if (!empty($ext)) 
		{
			// 	PHP 5.3.4: if (in_array($iter->getExtension(), $ext)) 
			if (in_array(pathinfo($iter->key(), PATHINFO_EXTENSION), $ext)) 
			{
				$files[$iter->key()] = hash_file("sha1", $iter->key());
			}
		} else {
			// 	ignore file extensions
			$files[$iter->key()] = hash_file("sha1", $iter->key());
		}
	}
	$iter->next();
}

//	Last Hash Scan

$results = mysqli_query($db,"SELECT tested FROM tested WHERE acct = '$acct' 
 	ORDER BY tested DESC LIMIT 1");
if ($results)
{
	while($result=mysqli_fetch_array($results))
	{
		$tested = $result['tested'];
	}
$report .= "Last tested $tested.\r\n";
}

//	Compare Hashed Files with Database Records

// 	identify differences
if (!empty($files)) 
{
	$result = mysqli_query($db,"SELECT * FROM baseline");
	if (!empty($result)) 
	{
		foreach ($result as $value) 
		{
			$baseline[$value["file_path"]] = $value["file_hash"];
		}
		$diffs = array_diff_assoc($files, $baseline);
		unset($baseline);
	}
}

// 	sort differences into Deleted, Altered and Added arrays
if (!empty($files)) 
{
	$results = mysqli_query($db,"SELECT file_path, file_hash FROM baseline WHERE acct = '$acct'");
	if (!empty($results)) 
	{
		$baseline = array();	// 	from database
		$diffs = array();		// 	differences between $files and $baseline
					// 	$files is current array of file_path => file_hash
		while ($value = mysqli_fetch_array($results))
		{
			if (!array_key_exists($value["file_path"], $files)) 
			{
				//	Deleted files
				$diffs["Deleted"][$value["file_path"]] = $value["file_path"];
				$baseline[$value["file_path"]] = $value["file_hash"];
			} else {
				//	Altered files
				if ($files[$value["file_path"]] <> $value["file_hash"]) 
				{
					$diffs["Altered"][$value["file_path"]] = $value["file_path"];
					$baseline[$value["file_path"]] = $value["file_path"];
				} else {
					//	Unchanged files
					$baseline[$value["file_path"]] = $value["file_hash"];
				}
			}
		}
		if (count($baseline) < count($files)) 
		{
			//	Added files
			$diffs["Added"] = array_diff_assoc($files, $baseline);
		}
		unset($baseline);
	}
}

//	E-Mail Results

// 	display discrepancies
if (!empty($diffs)) {
$report .= "The following discrepancies were found:\r\n\r\n";
foreach ($diffs as $status => $affected) 
{
	if (is_array($affected) && !empty($affected)) 
	{
		$report .= "* $status *\r\n\r\n";
		foreach($affected as $path => $hash) $report .= "  $path\r\n";
	}
}
} else {
	$report .= "File structure is intact.\r\n";
}

$mailed = mail('you@example.com', $acct . ' Integrity Monitor Report',$report);

//	Update the Database
// 	clear old records
mysqli_query($db,"DELETE FROM baseline WHERE acct = '$acct'");

// 	insert updated records
foreach ($files as $path => $hash) 
{
	mysqli_query($db,"INSERT INTO baseline (file_path, file_hash, acct) 
 		VALUES ('$path','$hash', '$acct')");
}

mysqli_query($db,"INSERT INTO tested (tested, acct) VALUES (NOW(), '$acct')");

mysqli_close($db);
?>